<?php class steamid {

/**
 * SteamID PHP Class
 * This class cross-calculates SteamIDs into all other forms of SteamID
 * I.e. if you give a SteamID3 as returned by Counter-Strike:Source by using
 * status command in game console (while playing on an online server) it
 * calculates the SteamID as used by most server-addons (like sourcemod) and
 * aswell the SteamID64 as uses i.e. by SteamAPI
 *
 *  Author: am1980 (http://am1980.de)
 *     for: Bierstube RELOADED (http://bierstube-reloaded.tk)
 * created: 31.01.2017
 * updated: 01.02.2017
 *
 * License: Creative Commons Attribution-ShareAlike 4.0 Inernational License
 * (CC-BY-SA)
 * https://creativecommons.org/licenses/by-sa/4.0/
 *
 * @author am1980
 * @version 1.0
 */

	private $input;
	private $input_type;
	private $id;
	private $id3;
	private $id64;


	/**
	 * The constructor of the class
	 * @param {string} input A SteamID formatted as SteamID, SteamID3/SteamID32 or SteamID64
         */
	public function __construct($input)
	{
		$this->input = $input;
		$id_type = array(
			0 => 'U',
			'U' => 0
		);
		$id32_type = array(
			'U' => 0x0110000100000000,
			'g' => 0x0170000000000000
		);
		if(count(explode('[',$input))>1)
		{
			$this->input_type='steamID3';
			$id3 = $input;
			$calc = explode('[', $input);
			$calc = explode(']', $calc[1]);
			$calc = explode(':', $calc[0]);
			$id64 = $calc[2]+$id32_type[$calc[0]];
			$id = 'STEAM_'.$id_type[$calc[0]].':'.($calc[2]%2).':'.( ($calc[2]-$calc[2]%2)/2 );
		} elseif(count(explode('STEAM',$input))>1)
		{
			$this->input_type='steamID';
			$id = $input;
			$calc = explode('_',$input);
			$calc = explode(':',$calc[1]);
			$id3 = '['.$id_type[$calc[0]].':1:'.($calc[2]*2+$calc[1]).']';
			$id64 = $calc[2]*2+$calc[1]+$id32_type[$id_type[$calc[0]]];
		} else
		{
			$this->input_type='steamID64';
			$id64 = $input;
			if($input<$id32_type['g'])
				$type = 'U';
			else
				$type = 'g';
			$id32 = $input-$id32_type[$type];
			$id3 = '['.$type.':1:'.$id32.']';
			$id = 'STEAM_'.$id_type[$type].':'.($id32%2).':'.(($id32-($id32%2))/2);
		}
		$this->id = $id;
		$this->id3 = $id3;
		$this->id64 = $id64;
	}

	/**
	 * Returns given input string
	 * @returns {string}
         */
	public function getInput()
	{
		return $this->input;
	}

	/**
	 * Returns steamid
	 * @returns {string}
         */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Returns steamid3 similar to steamid32
	 * @returns {string}
         */
	public function getId3()
	{
		return $this->id3;
	}

	/**
	 * Returns steamid3 similar to steamid32
	 * @returns {String}
         */
	public function getId32()
	{
		return $this->id3;
	}
	
	/**
	 * Returns steamid64
	 * @returns {Number}
         */
	public function getId64()
	{
		return $this->id64;
	}

	/**
	 * Returns recognized type of input string
	 * @returns {string}
         */
	public function getType()
	{
		return $this->input_type;
	}

	/**
	 * Returns url of SteamCommunitySite for given SteamID
	 * @returns {url}
         */
	public function getUrl()
	{
		return "http://steamcommunity.com/profiles/".$this->id64;
	}

	/**
	 * Returns all information of the Object in human readable form
	 * @returns {string}
         */
	public function __toString()
	{
		return "INPUT: ".$this->input."
 TYPE: ".$this->input_type."

   ID: ".$this->id."
 ID32: ".$this->id3."
 ID64: ".$this->id64;
	}
	
} // END OF CLASS
?>
